<link href="{$WEB_ROOT}/templates/{$template}/assets/css/store.css?v=1.0.0" rel="stylesheet">

<div class="marketconnect__page__wrapper full__with__section landing-page bg-white mail-services">
	<div class="main__page__content">
		<div class="store__page__promo__banner__wrapper">
			<div class="banner-background">
				<div class="banner-shape active">
					<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 0 800 400">
					<defs>
					<linearGradient id="linear-gradient" x1="556.06" y1="209.99" x2="585.29" y2="170.51" gradientTransform="matrix(1.38, -0.05, -0.06, -1.5, -148.97, 473.36)" gradientUnits="userSpaceOnUse"><stop offset="0" stop-color="#2c2e30"/><stop offset="1" stop-color="#1c1e20" stop-opacity="0"/></linearGradient>
					<mask id="mask" x="-398.07" y="-559.62" width="1106.37" height="1101.99" maskUnits="userSpaceOnUse">
					<g id="mask0"><path class="cls-1" d="M409.86-75.74a2.25,2.25,0,0,1,3.37,1.79V292.2a2.25,2.25,0,0,1-3.37,1.8L65.23,110.92a2,2,0,0,1,0-3.59Z"/></g>
					</mask>
					</defs>
					<path class="cls-2" d="M515.67,362,410,296.53,768.56-4.81l90.15,47.18Z"/>
					<path class="cls-3" d="M411.87,295.14V-.68H771.24L412.72,296Z"/>
					<path class="cls-4" d="M409.87-73.28a2.25,2.25,0,0,1,3.36,1.8V294.69a2.25,2.25,0,0,1-3.37,1.79L65.21,113.28l-.09-.09a3.91,3.91,0,0,1,0-5.63l.09-.09Z"/>
					<path class="cls-1" d="M409.86-75.74a2.25,2.25,0,0,1,3.37,1.79V292.2a2.25,2.25,0,0,1-3.37,1.8L65.23,110.92a2,2,0,0,1,0-3.59Z"/>
					<g class="cls-5">
					<path class="cls-6" d="M332.89-542.83l144,213.16c67.3,99.64,35.53,224.49-62.82,281S180.15-21,112.86-120.65l-144-213.16"/>
					<path class="cls-6" d="M-265.36,117.65l144.87-74.51C-52.78,8.32,24.41,22.76,53.78,71.32S55.92,188-11.79,222.85l-144.87,74.51"/>
					<path class="cls-6" d="M-384.35,88.85-154.72-29.26c107.33-55.2,234.15-24.92,286,60.74S144.36,232.53,37,287.74L-192.6,405.84"/>
					<path class="cls-6" d="M290.53,393c-86.6-79.86-85.19-209.81,2-290.24S520.71,21,607.32,100.88s85.2,209.81-2,290.24L465.17,520.32"/>
					<path class="cls-7" d="M558.07,342.64c-35.06,34.44-96.44,35.37-137.21.09s-43.64-91.83-8.58-126.27,96.44-35.37,137.2-.09S593.13,308.2,558.07,342.64Z"/>
					<path class="cls-7" d="M639,409.31c-62.41,61.32-179.82,57.77-262.73-14S282.09,215.75,344.5,154.43s179.83-57.76,262.73,14S701.41,348,639,409.31Z"/>
					</g>
					</svg>
				</div>
			</div>
			
			<div class="row justify-content-start">
				<div class="col-lg-5 col-md-6 col-12 order-md-first order-last d-flex flex-column justify-content-center">
					<div class="store__front__promo__hero__text caption">
						<svg style="width: 90px;height: auto;margin-bottom: 15px;" version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 744.8 198.9" style="enable-background:new 0 0 744.8 198.9;" xml:space="preserve">
						  <g id="Full_color_1_">
							<polygon fill="#C046FF" points="131.4,93 84.9,46.5 177.9,46.5 177.9,93 	"></polygon>
							<g>
								<polygon fill="#000" points="581.9,30.3 564.3,30.3 564.3,109.1 630.5,109.1 630.5,92.4 581.9,92.4 		"></polygon>
							  <polygon fill="#000" points="286.6,85.1 285.8,83.8 241.6,30.3 224.4,30.3 224.4,109.1 241.1,109.1 241.1,53.5 242.1,55.1
									286.7,109.1 303.3,109.1 303.3,30.3 286.6,30.3 		"></polygon>
							  <polygon fill="#000" points="84.8,46.5 84.8,46.4 38.5,0 0,0 0,131.4 46.5,131.4 46.5,84.9 93,131.4 131.4,131.4 131.4,93
									84.9,46.5 		"></polygon>
							  <polygon fill="#000" points="131.3,46.5 131.3,0 84.8,0 84.8,46.4 84.9,46.5 		"></polygon>
							  <rect x="318.8" y="60.8" fill="#000" width="44.8" height="17.9"></rect>
							  <path fill="#000" d="M533.4,68.4c5-1.1,8.7-3,11.1-5.6c2.4-2.7,3.6-6.5,3.6-11.4v-0.6c0-7.6-3-12.9-9-16c-6-3.1-15.2-4.6-27.5-4.6
									h-40.2v78.8h41.1c12.3,0,21.6-1.7,27.9-5.1c6.4-3.4,9.6-9.3,9.6-17.6V86c0-5.4-1.3-9.4-4-12.1C543.3,71.3,539.1,69.5,533.4,68.4z
									 M488.3,44.3h24.3c6.6,0,11.3,0.5,14.1,1.5c2.8,1,4.2,3.3,4.2,7v0.4c0,3.6-1.6,5.9-4.9,7c-3.3,1-7.6,1.5-12.9,1.5h-24.8V44.3z
									 M532.1,85.1c0,2.3-0.6,4.1-1.8,5.5c-1.2,1.4-3.4,2.3-6.5,2.8c-1.6,0.3-3.5,0.5-5.8,0.7c-2.2,0.1-4.9,0.2-7.8,0.2h-22V75.6h23.1
									c5.3,0,9.4,0.2,12.5,0.7c3,0.5,5.2,1.4,6.5,2.7c0.6,0.7,1,1.5,1.4,2.4c0.3,1,0.5,2.1,0.5,3.3V85.1z"></path>
							  <polygon fill="#000" points="661.3,77.1 706.3,77.1 706.3,62 661.3,62 661.3,45.2 714.4,45.2 714.4,30.3 644.6,30.3 644.6,109.1
									716.7,109.1 716.7,93.7 661.3,93.7 		"></polygon>
							  <path fill="#000" d="M404.2,30.3l-37.1,78.8h18.7l7.6-17.3h40.5l7.9,17.3h18.4l-37.6-78.8H404.2z M399.9,77.4l13.5-30.3l13.9,30.3
									H399.9z"></path>
							  <polygon fill="#000" points="723.3,32 726.8,32 726.8,40.6 728.7,40.6 728.7,32 732.2,32 732.2,30.3 723.3,30.3 		"></polygon>
							  <polygon fill="#000" points="744.8,40.6 744.8,30.3 743.3,30.3 739.5,36.6 735.7,30.3 734.2,30.3 734.2,40.6 736,40.6 736,33.9
									738.9,38.9 740.1,38.9 743,33.9 743,40.6 		"></polygon>
							</g>
						</g>
						  <g id="Mono_dark" style="display:none">
							<rect x="318.8" y="60.8" style="display:inline" width="44.8" height="17.9"></rect>
							<path style="display:inline" d="M131.3,0H84.8v46.4L38.5,0H0v131.4h46.5V84.9L93,131.4h38.5V93h46.5V41.8h-46.6V0z M173.3,46.5v41.8h-46.5
								L84.9,46.5H173.3z"></path>
							<polygon style="display:inline" points="286.6,85.1 285.8,83.8 241.6,30.3 224.4,30.3 224.4,109.1 241.1,109.1 241.1,53.5 242.1,55.1
								286.7,109.1 303.3,109.1 303.3,30.3 286.6,30.3 	"></polygon>
							<path style="display:inline" d="M404.2,30.3l-37.1,78.8h18.7l7.6-17.3h40.5l7.9,17.3h18.4l-37.6-78.8H404.2z M399.9,77.4l13.5-30.3l13.9,30.3
								H399.9z"></path>
							<path style="display:inline" d="M533.4,68.4c5-1.1,8.7-3,11.1-5.6c2.4-2.7,3.6-6.5,3.6-11.4v-0.6c0-7.6-3-12.9-9-16c-6-3.1-15.2-4.6-27.5-4.6
								h-40.2v78.8h41.1c12.3,0,21.6-1.7,27.9-5.1c6.4-3.4,9.6-9.3,9.6-17.6V86c0-5.4-1.3-9.4-4-12.1C543.3,71.3,539.1,69.5,533.4,68.4z
								 M488.3,44.3h24.3c6.6,0,11.3,0.5,14.1,1.5c2.8,1,4.2,3.3,4.2,7v0.4c0,3.6-1.6,5.9-4.9,7c-3.3,1-7.6,1.5-12.9,1.5h-24.8V44.3z
								 M532.1,85.1c0,2.3-0.6,4.1-1.8,5.5c-1.2,1.4-3.4,2.3-6.5,2.8c-1.6,0.3-3.5,0.5-5.8,0.7c-2.2,0.1-4.9,0.2-7.8,0.2h-22V75.6h23.1
								c5.3,0,9.4,0.2,12.5,0.7c3,0.5,5.2,1.4,6.5,2.7c0.6,0.7,1,1.5,1.4,2.4c0.3,1,0.5,2.1,0.5,3.3V85.1z"></path>
							<polygon style="display:inline" points="661.3,77.1 706.3,77.1 706.3,62 661.3,62 661.3,45.2 714.4,45.2 714.4,30.3 644.6,30.3 644.6,109.1
								716.7,109.1 716.7,93.7 661.3,93.7 	"></polygon>
							<polygon style="display:inline" points="581.9,30.3 564.3,30.3 564.3,109.1 630.5,109.1 630.5,92.4 581.9,92.4 	"></polygon>
							<polygon style="display:inline" points="744.8,40.6 744.8,30.3 743.3,30.3 739.5,36.6 735.7,30.3 734.2,30.3 734.2,40.6 736,40.6 736,33.9
								738.9,38.9 740.1,38.9 743,33.9 743,40.6 	"></polygon>
							<polygon style="display:inline" points="723.3,32 726.8,32 726.8,40.6 728.7,40.6 728.7,32 732.2,32 732.2,30.3 723.3,30.3 	"></polygon>
						</g>
						  <g id="Mono_light" style="display:none">
							<rect x="318.8" y="60.8" style="display:inline;fill:#000" width="44.8" height="17.9"></rect>
							<path style="display:inline;fill:#000" d="M131.3,0H84.8v46.4L38.5,0H0v131.4h46.5V84.9L93,131.4h38.5V93h46.5V41.8h-46.6V0z M173.3,46.5v41.8h-46.5
								L84.9,46.5H173.3z"></path>
							<polygon style="display:inline;fill:#000" points="286.6,85.1 285.8,83.8 241.6,30.3 224.4,30.3 224.4,109.1 241.1,109.1 241.1,53.5 242.1,55.1
								286.7,109.1 303.3,109.1 303.3,30.3 286.6,30.3 	"></polygon>
							<path style="display:inline;fill:#000" d="M404.2,30.3l-37.1,78.8h18.7l7.6-17.3h40.5l7.9,17.3h18.4l-37.6-78.8H404.2z M399.9,77.4l13.5-30.3l13.9,30.3
								H399.9z"></path>
							<path style="display:inline;fill:#000" d="M533.4,68.4c5-1.1,8.7-3,11.1-5.6c2.4-2.7,3.6-6.5,3.6-11.4v-0.6c0-7.6-3-12.9-9-16c-6-3.1-15.2-4.6-27.5-4.6
								h-40.2v78.8h41.1c12.3,0,21.6-1.7,27.9-5.1c6.4-3.4,9.6-9.3,9.6-17.6V86c0-5.4-1.3-9.4-4-12.1C543.3,71.3,539.1,69.5,533.4,68.4z
								 M488.3,44.3h24.3c6.6,0,11.3,0.5,14.1,1.5c2.8,1,4.2,3.3,4.2,7v0.4c0,3.6-1.6,5.9-4.9,7c-3.3,1-7.6,1.5-12.9,1.5h-24.8V44.3z
								 M532.1,85.1c0,2.3-0.6,4.1-1.8,5.5c-1.2,1.4-3.4,2.3-6.5,2.8c-1.6,0.3-3.5,0.5-5.8,0.7c-2.2,0.1-4.9,0.2-7.8,0.2h-22V75.6h23.1
								c5.3,0,9.4,0.2,12.5,0.7c3,0.5,5.2,1.4,6.5,2.7c0.6,0.7,1,1.5,1.4,2.4c0.3,1,0.5,2.1,0.5,3.3V85.1z"></path>
							<polygon style="display:inline;fill:#000" points="661.3,77.1 706.3,77.1 706.3,62 661.3,62 661.3,45.2 714.4,45.2 714.4,30.3 644.6,30.3 644.6,109.1
								716.7,109.1 716.7,93.7 661.3,93.7 	"></polygon>
							<polygon style="display:inline;fill:#000" points="581.9,30.3 564.3,30.3 564.3,109.1 630.5,109.1 630.5,92.4 581.9,92.4 	"></polygon>
							<polygon style="display:inline;fill:#000" points="744.8,40.6 744.8,30.3 743.3,30.3 739.5,36.6 735.7,30.3 734.2,30.3 734.2,40.6 736,40.6 736,33.9
								738.9,38.9 740.1,38.9 743,33.9 743,40.6 	"></polygon>
							<polygon style="display:inline;fill:#000" points="723.3,32 726.8,32 726.8,40.6 728.7,40.6 728.7,32 732.2,32 732.2,30.3 723.3,30.3 	"></polygon>
						</g>
						  <g>
							<g>
								<path fill="#000" d="M333.9,184.5c-3.1,0-5.9-0.5-8.4-1.6c-2.5-1.1-4.5-2.6-6.1-4.6c-1.6-2-2.7-4.4-3.1-7.1l6.5-1
									c0.7,2.6,2,4.7,4.1,6.2c2.1,1.5,4.5,2.2,7.3,2.2c1.7,0,3.3-0.3,4.8-0.8s2.6-1.3,3.5-2.4c0.9-1,1.3-2.3,1.3-3.7
									c0-0.8-0.1-1.5-0.4-2.1c-0.3-0.6-0.6-1.1-1.1-1.6c-0.5-0.5-1-0.8-1.7-1.2c-0.7-0.3-1.4-0.6-2.2-0.9l-11.1-3.3
									c-1.1-0.3-2.2-0.7-3.3-1.2c-1.1-0.5-2.1-1.2-3.1-2c-0.9-0.8-1.7-1.9-2.3-3.1c-0.6-1.2-0.9-2.7-0.9-4.5c0-2.7,0.7-4.9,2.1-6.8
									c1.4-1.8,3.2-3.2,5.6-4.2c2.3-1,5-1.4,7.9-1.4c2.9,0,5.5,0.6,7.8,1.6c2.3,1,4.2,2.4,5.8,4.3s2.6,4.1,3.2,6.8l-6.7,1.1
									c-0.3-1.6-0.9-3-1.9-4.2c-1-1.2-2.2-2.1-3.6-2.7s-3-1-4.6-1c-1.6,0-3.1,0.2-4.4,0.7c-1.3,0.5-2.4,1.2-3.2,2.2s-1.2,2-1.2,3.2
									c0,1.2,0.3,2.2,1,2.9c0.7,0.7,1.6,1.3,2.6,1.8c1,0.4,2.1,0.8,3.1,1.1l8,2.2c1,0.3,2.1,0.7,3.4,1.1c1.3,0.5,2.5,1.1,3.7,2
									c1.2,0.8,2.2,2,3,3.3c0.8,1.4,1.2,3.1,1.2,5.2c0,2.2-0.4,4.1-1.3,5.7s-2.1,3-3.6,4.1c-1.5,1.1-3.3,1.9-5.3,2.5
									C338.3,184.2,336.2,184.5,333.9,184.5z"></path>
							<path fill="#000" d="M356.9,198v-46.8h5.6v23.3h0.7V198H356.9z M372.1,184.5c-3.1,0-5.7-0.8-7.8-2.3c-2.1-1.5-3.7-3.6-4.8-6.1
									s-1.6-5.5-1.6-8.7c0-3.2,0.5-6.1,1.6-8.7c1.1-2.6,2.6-4.6,4.7-6.1c2.1-1.5,4.7-2.2,7.7-2.2c3,0,5.7,0.7,7.9,2.2
									c2.2,1.5,3.9,3.5,5.1,6.1c1.2,2.6,1.8,5.5,1.8,8.7c0,3.2-0.6,6.2-1.8,8.7c-1.2,2.6-2.9,4.6-5.1,6.1
									C377.7,183.7,375.1,184.5,372.1,184.5z M371.2,178.8c2,0,3.7-0.5,5-1.5c1.3-1,2.3-2.4,2.9-4.1c0.6-1.7,1-3.7,1-5.8
									c0-2.1-0.3-4-1-5.8c-0.7-1.7-1.6-3.1-3-4.1c-1.3-1-3-1.5-5.1-1.5c-2,0-3.6,0.5-4.8,1.4c-1.3,1-2.2,2.3-2.8,4
									c-0.6,1.7-0.9,3.7-0.9,5.9c0,2.2,0.3,4.2,0.9,5.9c0.6,1.7,1.5,3.1,2.8,4C367.5,178.3,369.2,178.8,371.2,178.8z"></path>
							<path fill="#000" d="M402.5,184.5c-2.4,0-4.4-0.4-6-1.3s-2.8-2.1-3.7-3.5c-0.8-1.5-1.2-3.1-1.2-4.8c0-1.6,0.3-3.1,0.9-4.3
									s1.4-2.3,2.6-3.2c1.1-0.9,2.5-1.6,4.2-2.1c1.4-0.4,3.1-0.8,4.9-1.1c1.8-0.3,3.7-0.6,5.7-0.9c2-0.3,4-0.6,6-0.8l-2.3,1.3
									c0-2.5-0.5-4.4-1.6-5.7c-1.1-1.2-3-1.8-5.7-1.8c-1.7,0-3.3,0.4-4.7,1.2s-2.4,2.1-3,3.9l-5.8-1.8c0.8-2.8,2.3-5,4.6-6.6
									s5.2-2.5,9-2.5c2.9,0,5.4,0.5,7.6,1.5c2.1,1,3.7,2.6,4.7,4.7c0.5,1.1,0.8,2.2,1,3.4s0.2,2.5,0.2,3.8v20h-5.6v-7.4l1.1,1
									c-1.3,2.5-3,4.3-5.1,5.5C408.1,183.9,405.5,184.5,402.5,184.5z M403.6,179.4c1.8,0,3.3-0.3,4.6-0.9s2.3-1.4,3.1-2.4
									c0.8-1,1.3-2,1.5-3.1c0.3-1,0.5-2,0.6-3.2c0-1.2,0.1-2.2,0.1-2.9l2,0.8c-2,0.3-3.8,0.6-5.4,0.8s-3.1,0.5-4.4,0.7
									c-1.3,0.2-2.5,0.5-3.5,0.8c-0.9,0.3-1.6,0.7-2.3,1.1c-0.7,0.4-1.2,0.9-1.6,1.5c-0.4,0.6-0.6,1.3-0.6,2.2c0,0.8,0.2,1.6,0.6,2.3
									s1.1,1.3,1.9,1.7C401.2,179.2,402.3,179.4,403.6,179.4z"></path>
							<path fill="#000" d="M427.5,183.6v-32.4h5.6v9.4h0.7v23H427.5z M447,183.6l0-20.1c0-2.4-0.6-4.2-1.8-5.5c-1.2-1.3-2.8-2-4.8-2
									c-2,0-3.6,0.7-4.8,2c-1.2,1.4-1.8,3.1-1.8,5.3l-3-1.9c0-2.1,0.5-4,1.5-5.7s2.4-3,4.1-3.9c1.7-1,3.7-1.4,5.9-1.4
									c2.3,0,4.3,0.5,5.9,1.5s2.9,2.3,3.7,4.1c0.8,1.7,1.3,3.8,1.3,6.1l0,21.6H447z M466.4,183.6l0-20.2c0-2.3-0.6-4.2-1.8-5.5
									c-1.2-1.3-2.8-2-4.7-2c-1.2,0-2.3,0.3-3.3,0.8c-1,0.5-1.8,1.4-2.4,2.5c-0.6,1.1-0.9,2.5-0.9,4.1l-3-1.5c0-2.3,0.4-4.3,1.5-6
									c1-1.7,2.4-3.1,4.1-4c1.7-0.9,3.7-1.4,5.8-1.4c3.5,0,6.2,1,8.1,3.2c1.9,2.1,2.9,4.9,2.9,8.4l0,21.7H466.4z"></path>
							<path fill="#000" d="M480.5,183.6v-43.2h27.6v5.9h-21.3v12.1h17.7v5.9h-17.7v13.3h21.3v5.9H480.5z"></path>
							<path fill="#000" d="M511.7,183.6l12.1-16.4l-11.8-16h7.4l8.1,11.1l8-11.1h7.4l-11.8,16l12.1,16.4h-7.5l-8.2-11.5l-8.3,11.5H511.7
									z"></path>
							<path fill="#000" d="M547.9,198v-46.8h5.6v23.3h0.7V198H547.9z M563.2,184.5c-3.1,0-5.7-0.8-7.8-2.3c-2.1-1.5-3.7-3.6-4.8-6.1
									s-1.6-5.5-1.6-8.7c0-3.2,0.5-6.1,1.6-8.7c1.1-2.6,2.6-4.6,4.7-6.1c2.1-1.5,4.7-2.2,7.7-2.2c3,0,5.7,0.7,7.9,2.2
									c2.2,1.5,3.9,3.5,5.1,6.1c1.2,2.6,1.8,5.5,1.8,8.7c0,3.2-0.6,6.2-1.8,8.7c-1.2,2.6-2.9,4.6-5.1,6.1
									C568.8,183.7,566.2,184.5,563.2,184.5z M562.3,178.8c2,0,3.7-0.5,5-1.5c1.3-1,2.3-2.4,2.9-4.1c0.6-1.7,1-3.7,1-5.8
									c0-2.1-0.3-4-1-5.8c-0.7-1.7-1.6-3.1-3-4.1c-1.3-1-3-1.5-5.1-1.5c-2,0-3.6,0.5-4.8,1.4c-1.3,1-2.2,2.3-2.8,4
									c-0.6,1.7-0.9,3.7-0.9,5.9c0,2.2,0.3,4.2,0.9,5.9c0.6,1.7,1.5,3.1,2.8,4C558.6,178.3,560.2,178.8,562.3,178.8z"></path>
							<path fill="#000" d="M598.8,184.5c-3.2,0-6-0.7-8.5-2.1c-2.4-1.4-4.3-3.4-5.7-5.9c-1.3-2.5-2-5.5-2-8.8c0-3.5,0.7-6.6,2-9.2
									s3.2-4.6,5.6-6s5.1-2.1,8.3-2.1c3.3,0,6.1,0.8,8.4,2.3c2.3,1.5,4.1,3.7,5.2,6.5c1.1,2.8,1.6,6.2,1.4,10.1h-6.3v-2.3
									c0-3.8-0.8-6.5-2.1-8.3c-1.4-1.8-3.5-2.7-6.3-2.7c-3.1,0-5.5,1-7.1,3c-1.6,2-2.4,4.8-2.4,8.6c0,3.6,0.8,6.3,2.4,8.3
									c1.6,1.9,3.9,2.9,6.8,2.9c2,0,3.7-0.4,5.1-1.3c1.4-0.9,2.5-2.2,3.3-3.8l6.1,2c-1.3,2.9-3.2,5.1-5.7,6.7
									C604.8,183.7,602,184.5,598.8,184.5z M587.3,169.2v-4.9h23.1v4.9H587.3z"></path>
							<path fill="#000" d="M620.2,183.6v-32.4h5.6v7.9l-0.8-1c0.4-1,0.9-2,1.6-2.9c0.6-0.9,1.4-1.6,2.2-2.1c0.8-0.6,1.7-1.1,2.7-1.4
									c1-0.3,2-0.5,3.1-0.6c1.1-0.1,2.1,0,3.1,0.2v5.9c-1.1-0.3-2.2-0.4-3.5-0.2s-2.5,0.5-3.6,1.2c-1,0.7-1.8,1.5-2.4,2.4
									c-0.6,0.9-1,2-1.3,3.1c-0.3,1.2-0.4,2.4-0.4,3.6v16.3H620.2z"></path>
							<path fill="#000" d="M639.8,156.2v-5H662v5H639.8z M662,183.6c-2,0.4-4,0.6-6,0.5c-2-0.1-3.7-0.4-5.2-1.1
									c-1.5-0.7-2.7-1.8-3.5-3.3c-0.7-1.3-1.1-2.7-1.1-4.1c0-1.4-0.1-3-0.1-4.7v-28.7h6.3v28.4c0,1.3,0,2.4,0,3.4c0,1,0.2,1.8,0.6,2.4
									c0.7,1.2,1.9,1.9,3.4,2.1c1.6,0.2,3.4,0.1,5.5-0.2V183.6z"></path>
							<path fill="#000" d="M681.2,184.5c-3.9,0-7.2-0.9-9.6-2.6c-2.5-1.7-4-4.2-4.6-7.3l6.4-1c0.4,1.7,1.3,3,2.8,4
									c1.5,1,3.3,1.5,5.4,1.5c2,0,3.5-0.4,4.6-1.2c1.1-0.8,1.7-1.9,1.7-3.3c0-0.8-0.2-1.5-0.6-2c-0.4-0.5-1.2-1-2.4-1.5s-3.1-1-5.7-1.7
									c-2.8-0.7-5-1.5-6.6-2.3s-2.8-1.8-3.5-2.9c-0.7-1.1-1-2.5-1-4c0-2,0.5-3.7,1.6-5.1s2.5-2.6,4.4-3.4c1.9-0.8,4.1-1.2,6.6-1.2
									c2.5,0,4.7,0.4,6.6,1.2c1.9,0.8,3.5,1.9,4.7,3.3c1.2,1.4,1.9,3.1,2.2,5l-6.4,1.2c-0.2-1.6-1-2.8-2.2-3.7c-1.2-0.9-2.9-1.4-4.8-1.5
									c-1.9-0.1-3.4,0.2-4.6,0.9c-1.2,0.7-1.8,1.7-1.8,2.9c0,0.7,0.2,1.3,0.7,1.8c0.5,0.5,1.3,1,2.6,1.4c1.3,0.5,3.2,1,5.8,1.6
									c2.7,0.7,4.9,1.5,6.5,2.3c1.6,0.9,2.7,1.9,3.4,3c0.7,1.2,1,2.6,1,4.2c0,3.2-1.2,5.7-3.5,7.5C688.5,183.6,685.3,184.5,681.2,184.5z
									"></path>
							<path fill="#000" d="M701.1,148.2v-7.1h-3v-1.6h7.7v1.6h-3v7.1H701.1z M707.5,148.2v-8.7h1.5l3.1,5l3.1-5h1.5v8.7h-1.7v-5.4
									l-2.3,3.9h-1l-2.3-3.9v5.4H707.5z"></path>
							</g>
						</g>
						</svg>
						<h6 class="promo__title coodiv-text-4 font-weight-700 mt-2">{lang key="store.emailServices.headline"}</h6>
						<p class="promo__sub__title coodiv-text-8 font-weight-300 mt-4">{lang key="store.emailServices.tagline"} & {lang key="store.emailServices.blockSpamHeadline"}</p>
										
						<div class="promo__btns banner__actions__btns mt-10">
							<a href="#" class="btn btn-lg btn-primary" onclick="smoothScroll('#overview');return false">{lang key="store.emailServices.overview.learn"}</a>
							<a href="#" class="btn btn-lg btn-primary-outline" onclick="smoothScroll('#pricing');return false">{lang key="store.emailServices.overview.buy"}</a>
						</div>
					</div>
				</div>
				<div class="col-lg-7 col-md-6 col-12 pr-lg-15 order-md-last order-first">
					<div class="store__front__promo__hero__illustration">
						<div class="promo__slider__illunsration__item">
							{if file_exists("templates/$template/assets/svg/orderform/spamexperts-illustration.tpl")}
								{include file="{$template}/assets/svg/orderform/spamexperts-illustration.tpl"}
							{/if}
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>

	<div class="py-14 white-bg position-relative">
		<div class="inner__page__content__container">
			<div class="row justify-content-center px-lg-0 px-10 mb-13">
				<div class="col-lg-8 col-11 text-center">
					<h2 class="coodiv-text-5 font-weight-700 mb-4">{lang key="store.emailServices.blockSpamHeadline"}</h2>
					<p class="coodiv-text-9 font-weight-400">{lang key="store.emailServices.faqs.a4"}</p>
				</div>
			</div>
			{if $numberOfFeaturedProducts > 0}
			<div class="row main__features__store__blocks">
				{if $products.incoming}
				<div class="col-md-4 col-sm-6 mb-8">
					<div class="feature text-center flex-column">
					<div class="icon">
						<i class="fad fa-inbox-in"></i>
					</div>
					<div class="text">
					<h4 class="coodiv-text-9 font-weight-bold mb-4">{lang key="store.emailServices.incoming.title"} <small class="d-block">{lang key="store.emailServices.overview.incoming.tagline"}</small></h4>
					<p class="coodiv-text-11 font-weight-400 mb-8">{lang key="store.emailServices.overview.incoming.headline"}</p>
					<div class="price-wrapper mb-7">
					{if $products.incoming->pricing()->best()}
						<h6 class="price coodiv-text-8 font-weight-bold">{lang key="from"} {$products.incoming->pricing()->best()->toFullString()}/<small>{lang key="store.emailServices.domain"}</small></h6>
					{elseif $inPreview}
						<h6 class="price coodiv-text-8 font-weight-bold">-</h6>
					{/if}
					</div>
					<a href="#" data-target="incoming" class="btn btn-primary coodiv-text-11 coodiv-hover-y px-13 btn-buy">{lang key="store.emailServices.overview.buy"}</a>
					<a href="#" class="coodiv-text-11 font-weight-light d-block mt-3 btn-learn-more" data-target="incoming">{lang key="store.emailServices.overview.learn"}</a>
					</div>
					</div>
				</div>
				{/if}
				
				{if $products.outgoing}
				<div class="col-md-4 col-sm-6 mb-8">
					<div class="feature text-center flex-column">
					<div class="icon">
						<i class="fad fa-mailbox"></i>
					</div>
					<div class="text">
					<h4 class="coodiv-text-9 font-weight-bold mb-4">{lang key="store.emailServices.outgoing.title"} <small class="d-block">{lang key="store.emailServices.overview.outgoing.tagline"}</small></h4>
					<p class="coodiv-text-11 font-weight-400 mb-8">{lang key="store.emailServices.overview.outgoing.headline"}</p>
					<div class="price-wrapper mb-7">
					{if $products.outgoing->pricing()->best()}
						<h6 class="price coodiv-text-8 font-weight-bold">{lang key="from"} {$products.outgoing->pricing()->best()->toFullString()} <small>/{lang key="store.emailServices.domain"}</small></h6>
					{elseif $inPreview}
						<h6 class="price coodiv-text-8 font-weight-bold">-</h6>
					{/if}
					</div>
					<a href="#" data-target="outgoing" class="btn btn-primary coodiv-text-11 coodiv-hover-y px-13 btn-buy">{lang key="store.emailServices.overview.buy"}</a>
					<a href="#" class="coodiv-text-11 font-weight-light d-block mt-3 btn-learn-more" data-target="outgoing">{lang key="store.emailServices.overview.learn"}</a>
					</div>
					</div>
				</div>
				{/if}
				
				
				{if $products.incomingarchiving || $products.outgoingarchiving || $products.incomingoutgoingarchiving}
				<div class="col-md-4 col-sm-6 mb-8">
					<div class="feature text-center flex-column">
					<div class="icon">
						<i class="fad fa-save"></i>
					</div>
					<div class="text">
					<h4 class="coodiv-text-9 font-weight-bold mb-4">{lang key="store.emailServices.archiving.title"} <small class="d-block">{lang key="store.emailServices.overview.archiving.tagline"}</small></h4>
					<p class="coodiv-text-11 font-weight-400 mb-8">{lang key="store.emailServices.overview.archiving.headline"}</p>
					<div class="price-wrapper mb-7">
					{if $products.incomingarchiving && $products.incomingarchiving->pricing()->best()}
						<h6 class="price coodiv-text-8 font-weight-bold">{lang key="from"} {$products.incomingarchiving->pricing()->best()->toFullString()} <small>/{lang key="store.emailServices.domain"}</small></h6>
					{elseif $products.outgoingarchiving && $products.outgoingarchiving->pricing()->best()}
						<h6 class="price coodiv-text-8 font-weight-bold">{lang key="from"} {$products.outgoingarchiving->pricing()->best()->toFullString()} <small>/{lang key="store.emailServices.domain"}</small></h6>
					{elseif $products.incomingoutgoingarchiving->pricing()->best()}
						<h6 class="price coodiv-text-8 font-weight-bold">{lang key="from"} {$products.incomingoutgoingarchiving->pricing()->best()->toFullString()} <small>/{lang key="store.emailServices.domain"}</small></h6>
					{elseif $inPreview}
						<h6 class="price coodiv-text-8 font-weight-bold">-</h6>
					{/if}
					</div>		
					<a href="#" data-target="archiving" class="btn btn-primary coodiv-text-11 coodiv-hover-y px-13 btn-buyy">{lang key="store.emailServices.overview.buy"}</a>
					<a href="#" class="coodiv-text-11 font-weight-light d-block mt-3 btn-learn-more" data-target="archiving">{lang key="store.emailServices.overview.learn"}</a>
					</div>
					</div>
				</div>
				{/if}
				
				
			</div>
			{elseif $inPreview}
				<div class="text-center lead preview-text">Email service products you activate will be displayed here</div>
			{/if}
		</div>
	</div>
	
	
	
	<div class="full__width__secondarysidebar__menu white-bg">
		<div class="main__page__content">
			<ul class="nav" id="pills-tab" role="tablist">
				{if $products.incoming || $inPreview}
					<li class="nav-item"><a class="nav-link active" id="incoming-tab" href="#incoming" role="tab" data-toggle="tab" aria-controls="incoming" aria-selected="true">{lang key="store.emailServices.incoming.title"}</a></li>
				{/if}
				{if $products.outgoing || $inPreview}			
					<li class="nav-item"><a class="nav-link" id="outgoing-tab" href="#outgoing" role="tab" data-toggle="tab" aria-controls="outgoing" aria-selected="false">{lang key="store.emailServices.outgoing.title"}</a></li>
				{/if}
				{if $products.incomingarchiving || $products.outgoingarchiving || $products.incomingoutgoingarchiving || $inPreview}
					<li class="nav-item"><a class="nav-link" id="archiving-tab" href="#archiving" role="tab" data-toggle="tab" aria-controls="archiving" aria-selected="false">{lang key="store.emailServices.archiving.title"}</a></li>
				{/if}
			</ul>
		</div>
	</div>

    <div class="pb-17 pt-7 tabs" id="howitworks">
        <div class="main__page__content">
            <div class="tab-content p-0">
                <div class="tab-pane active" id="incoming" role="tabpanel" aria-labelledby="incoming-tab">
                    <div class="mb-10">
                        <h6 class="coodiv-text-8 font-weight-700">{lang key="store.emailServices.benefits.incoming.title"}</h6>
                        <div class="row">
							<div class="col-lg-6 col-12">
								<ul class="default__list__features">
									<li><i class="fal fa-check"></i>{lang key="store.emailServices.benefits.incoming.1"}</li>
									<li><i class="fal fa-check"></i>{lang key="store.emailServices.benefits.incoming.2"}</li>
									<li><i class="fal fa-check"></i>{lang key="store.emailServices.benefits.incoming.3"}</li>
									<li><i class="fal fa-check"></i>{lang key="store.emailServices.benefits.incoming.4"}</li>
								</ul>
							</div>
							<div class="col-lg-6 col-12">
								<ul class="default__list__features">
									<li><i class="fal fa-check"></i>{lang key="store.emailServices.benefits.incoming.5"}</li>
									<li><i class="fal fa-check"></i>{lang key="store.emailServices.benefits.incoming.6"}</li>
									<li><i class="fal fa-check"></i>{lang key="store.emailServices.benefits.incoming.7"}</li>
									<li><i class="fal fa-check"></i>{lang key="store.emailServices.benefits.incoming.8"}</li>
								</ul>
							</div>
                        </div>
                    </div>

                    <h6 class="coodiv-text-9 font-weight-700">{lang key="store.emailServices.benefits.incoming.q1"}</h6>
                    <p class="coodiv-text-11 font-weight-400">{lang key="store.emailServices.benefits.incoming.a1"}</p>

                    <h6 class="coodiv-text-9 font-weight-700 mt-4">{lang key="store.emailServices.benefits.incoming.q2"}</h6>
                    <p class="coodiv-text-11 font-weight-400">{lang key="store.emailServices.benefits.incoming.a2"}</p>

                    <h6 class="coodiv-text-9 font-weight-700 mt-4">{lang key="store.emailServices.benefits.incoming.q3"}</h6>
                    <p class="coodiv-text-11 font-weight-400">{lang key="store.emailServices.benefits.incoming.a3"}</p>

                </div>
                <div class="tab-pane" id="outgoing" role="tabpanel" aria-labelledby="outgoing-tab">
				
					<div class="mb-10">
                        <h6 class="coodiv-text-8 font-weight-700">{lang key="store.emailServices.benefits.outgoing.title"}</h6>
                        <div class="row">
							<div class="col-lg-6 col-12">
								<ul class="default__list__features">
									<li><i class="fal fa-check"></i>{lang key="store.emailServices.benefits.outgoing.1"}</li>
									<li><i class="fal fa-check"></i>{lang key="store.emailServices.benefits.outgoing.2"}</li>
									<li><i class="fal fa-check"></i>{lang key="store.emailServices.benefits.outgoing.3"}</li>
								</ul>
							</div>
							<div class="col-lg-6 col-12">
								<ul class="default__list__features">
									<li><i class="fal fa-check"></i>{lang key="store.emailServices.benefits.outgoing.4"}</li>
									<li><i class="fal fa-check"></i>{lang key="store.emailServices.benefits.outgoing.5"}</li>
									<li><i class="fal fa-check"></i>{lang key="store.emailServices.benefits.outgoing.6"}</li>
								</ul>
							</div>
                        </div>
                    </div>

                    <h6 class="coodiv-text-9 font-weight-700">{lang key="store.emailServices.benefits.outgoing.q1"}</h6>
                    <p class="coodiv-text-11 font-weight-400">{lang key="store.emailServices.benefits.outgoing.a1"}</p>

                    <h6 class="coodiv-text-9 font-weight-700 mt-4">{lang key="store.emailServices.benefits.outgoing.q2"}</h6>
                    <p class="coodiv-text-11 font-weight-400">{lang key="store.emailServices.benefits.outgoing.a2"}</p>

                </div>
                <div class="tab-pane" id="archiving" role="tabpanel" aria-labelledby="archiving-tab">
				
					<div class="mb-10">
                        <h6 class="coodiv-text-8 font-weight-700">{lang key="store.emailServices.benefits.archiving.title"}</h6>
                        <div class="row">
							<div class="col-lg-6 col-12">
								<ul class="default__list__features">
									<li><i class="fal fa-check"></i>{lang key="store.emailServices.benefits.archiving.1"}</li>
									<li><i class="fal fa-check"></i>{lang key="store.emailServices.benefits.archiving.2"}</li>
									<li><i class="fal fa-check"></i>{lang key="store.emailServices.benefits.archiving.3"}</li>
									<li><i class="fal fa-check"></i>{lang key="store.emailServices.benefits.archiving.4"}</li>
								</ul>
							</div>
							<div class="col-lg-6 col-12">
								<ul class="default__list__features">
									<li><i class="fal fa-check"></i>{lang key="store.emailServices.benefits.archiving.5"}</li>
									<li><i class="fal fa-check"></i>{lang key="store.emailServices.benefits.archiving.6"}</li>
									<li><i class="fal fa-check"></i>{lang key="store.emailServices.benefits.archiving.7"}</li>
								</ul>
							</div>
                        </div>
                    </div>

                    <h6 class="coodiv-text-9 font-weight-700">{lang key="store.emailServices.benefits.archiving.q1"}</h6>
                    <p class="coodiv-text-11 font-weight-400">{lang key="store.emailServices.benefits.archiving.a1"}</p>

                    <h6 class="coodiv-text-9 font-weight-700 mt-4">{lang key="store.emailServices.benefits.archiving.q2"}</h6>
                    <p class="coodiv-text-11 font-weight-400">{lang key="store.emailServices.benefits.archiving.a2a"}</p>
                    <p class="coodiv-text-11 font-weight-400">{lang key="store.emailServices.benefits.archiving.a2b"}</p>
                </div>
            </div>
        </div>
    </div>

	<div class="get-started border-top-light mt-0 white-bg pt-lg-15 pt-5" id="pricing">
        <div class="inner__page__content__container">
            <form method="post" action="{routePath('cart-order')}">
                <input type="hidden" name="productkey" value="{$products.incoming->productKey}" id="productKey">
				<div class="row justify-content-center">
					<div class="col-md-8 col-12 text-center">
						<h6 class="coodiv-text-6 font-weight-bold mb-2">{lang key="store.emailServices.signup.title"}</h6>
                        <p class="coodiv-text-10">{lang key="store.emailServices.signup.choose"}</p>
					</div>
				</div>
				
				{if count($plans) > 0}
				{if !$loggedin && $currencies}
				<div class="row justify-content-center">
					<div class="col-md-4 col-12">
						<form method="post" action="">
							<select name="currency" class="form-control ssl-currency-selector" onchange="submit()">
								<option>{lang key="changeCurrency"} ({$activeCurrency.prefix} {$activeCurrency.code})</option>
								{foreach $currencies as $currency}
									<option value="{$currency['id']}">{$currency['prefix']} {$currency['code']}</option>
								{/foreach}
							</select>
						</form>
					</div>
				</div>
				{/if}
				{/if}
				
				
				
				<div class="row justify-content-center mt-8">
				<div class="col-12 col-md-6 mb-8 mb-lg-0">
					<div class="pricing-plans-special border rounded-8 pt-8 pb-8 px-9 white-bg h-100 d-flex flex-column">
						
						<nav>
						 {if $numberOfFeaturedProducts > 0}
						  <div class="nav vps-server-tabs-switch justify-content-center choose-product" role="group">
							{if $products.incoming}
							<button type="button" class="active" data-product="incoming"><h5 class="coodiv-text-9 font-weight-bold"><span>{lang key="store.emailServices.overview.incoming.tagline"}</span>{lang key="store.emailServices.options.incomingFilter"}</h5></button>
							{/if}
							{if $products.outgoing}
							<button type="button" data-product="outgoing"><h5 class="coodiv-text-9 font-weight-bold"><span>{lang key="store.emailServices.overview.outgoing.tagline"}</span>{lang key="store.emailServices.options.outgoingFilter"}</h5></button>
							{/if}
						  </div>
						  {elseif $inPreview}
							{lang key="store.emailServices.preview"}
						{/if}
						</nav>
						
						<div class="buttom-pricing-element mt-auto">
											
						{if $products.incoming && $products.incoming->pricing()->best()}
						<div class="price price-incoming">
						<div class="pricing d-flex align-items-center mt-10 mb-2">	
                            <span class="coodiv-text-4 font-weight-bold color-blackish-blue mr-4">{$products.incoming->pricing()->best()->toFullString()}</span>
						</div>
						</div>
					    {/if}
                        {if $products.incomingarchiving && $products.incomingarchiving->pricing()->best()}
						<div class="price price-incomingarchiving">
						<div class="pricing d-flex align-items-center mt-10 mb-2">
                            <span class="coodiv-text-4 font-weight-bold color-blackish-blue mr-4">{$products.incomingarchiving->pricing()->best()->toFullString()}</span>
                        </div>
						</div>
						{/if}
                        {if $products.outgoing && $products.outgoing->pricing()->best()}
						<div class="price price-outgoing">
						<div class="pricing d-flex align-items-center mt-10 mb-2">
                            <span class="coodiv-text-4 font-weight-bold color-blackish-blue mr-4">{$products.outgoing->pricing()->best()->toFullString()}</span>
                        </div>
						</div>
						{/if}
                        {if $products.outgoingarchiving && $products.outgoingarchiving->pricing()->best()}
						<div class="price price-outgoingarchiving">
						<div class="pricing d-flex align-items-center mt-10 mb-2">
                            <span class="coodiv-text-4 font-weight-bold color-blackish-blue mr-4">{$products.outgoingarchiving->pricing()->best()->toFullString()}</span>
                        </div>
						</div>
						{/if}
                        {if $products.incomingoutgoing && $products.incomingoutgoing->pricing()->best()}
						<div class="price price-incomingoutgoing">
						<div class="pricing d-flex align-items-center mt-10 mb-2">
                            <span class="coodiv-text-4 font-weight-bold color-blackish-blue mr-4">{$products.incomingoutgoing->pricing()->best()->toFullString()}</span>
                        </div>
						</div>
						{/if}
						<div class="price price-incomingoutgoingarchiving">
						<div class="pricing d-flex align-items-center mt-10 mb-2">
                        {if $products.incomingoutgoingarchiving && $products.incomingoutgoingarchiving->pricing()->best()}
                            <span class="coodiv-text-4 font-weight-bold color-blackish-blue mr-4">{$products.incomingoutgoingarchiving->pricing()->best()->toFullString()}</span>
                        </div>
						</div>
						{/if}
						</div>
						
						<strong class="plan-highlight mb-7">Save more money with annual term</strong>
						<button type="submit" type="button" class="btn btn-outline-dark d-block w-100 coodiv-text-12">{lang key="store.emailServices.signup.order"}</button>
						
						<div class="d-block mt-8 pb-5">
						
						<h4 class="coodiv-text-10 mb-5 font-weight-bold">{lang key="store.emailServices.signup.additional"}</h4>
                        <div class="additional-options">
                            {foreach $productOptions as $productKey => $options}
                                <div class="option options-{$productKey}">
                                    {foreach $options as $option}
									<div class="form-group mb-1">
										<label for="{$option.product}" class="coodiv-check-input d-flex">
											<input type="hidden" name="email_preferences[{$emailType}]" value="0">
											<input type="checkbox" class="coodiv-check-input-click" name="options"  value="{$option.product}"/>
											<span class="checkbox mr-2"></span>
											<p class="coodiv-text-11 font-weight-500 mb-0 pl-3">{lang key="store.emailServices.options.addFor" description=$option.description pricing=$option.pricing->toFullString()}</p>
										</label>
									</div>
                                    {foreachelse}
                                        {lang key="store.emailServices.signup.none"}
                                    {/foreach}
                                </div>
                            {/foreach}
                        </div>
						
						</div>
						</div>
					</div>
				</div>
			</div>
        </form>
    </div>
	
	<div class="py-14 white-bg position-relative">
		<div class="inner__page__content__container">
			<div class="row justify-content-center px-lg-0 px-10 mb-13">
				<div class="col-lg-8 col-11 text-center">
					<h2 class="coodiv-text-5 font-weight-700 mb-4">{lang key="store.emailServices.faqs.title"}</h2>
				</div>
			</div>
			
			<div class="row justify-content-center">
				<div class="col-xl-8 col-lg-9">
					<div class="accordion coodiv__faq__accordions__wrapper" id="accordionFaqsection">
					{foreach [[1,2,3,4,5,6]] as $columns}
						{foreach $columns as $row}
						<div class="coodiv__faq__accordions__item">
							<div class="coodiv__faq__accordions__item__header" id="heading-{$row}">
								<button class="btn-reset coodiv-text-10 font-weight-700 accordion-trigger arrow-icon w-100" type="button" data-toggle="collapse" data-target="#collapse-{$row}" aria-expanded="false" aria-controls="collapse-{$row}">
									{lang key="store.emailServices.faqs.q$row"}
								</button>
							</div>
							<div id="collapse-{$row}" class="collapse coodiv__faq__accordions__item__body" aria-labelledby="heading-{$row}" data-parent="#accordionFaqsection">
								<div class="coodiv-text-11 font-weight-400">
									{lang key="store.emailServices.faqs.a$row"}
								</div>
							</div>
						</div>	
						{/foreach}	
					{/foreach}	
					</div>
				</div>
			</div>
		</div>
		<div class="container text-center pt-10">
			<img style="width: 120px" src="{$WEB_ROOT}/assets/img/marketconnect/spamexperts/logo.png">
		</div>
	</div>


	

</div>

<script>
    $(document).ready(function() {
        $('#inputDomainChooser').multiselect({
            buttonWidth: '250px',
            dropRight: true,
            nonSelectedText: 'Choose domain(s)'
        });

        $('.landing-page.mail-services .get-started .choose-product button').click(function(e) {
            var product = $(this).data('product');
            $('.landing-page.mail-services .get-started .choose-product button').removeClass('active');
            $(this).addClass('active');
            $('.landing-page.mail-services .get-started .additional-options .option').hide();
            $('.landing-page.mail-services .get-started .additional-options .options-' + product).show();
            $('.landing-page.mail-services .get-started .price').hide();
            $('.landing-page.mail-services .get-started .price-' + product).show();
            $('#productKey').val('spamexperts_' + product);
        });

        $('.landing-page.mail-services .get-started .additional-options input[type="checkbox"]').click(function(e) {
            if ($(this).is(":checked")) {
                $('.landing-page.mail-services .get-started .additional-options input[type="checkbox"]').not($(this)).prop('checked', false);
                $('.landing-page.mail-services .get-started .price').hide();
                $('.landing-page.mail-services .get-started .price-' + $(this).val()).show();
                $('#productKey').val('spamexperts_' + $(this).val());
            } else {
                var product = $('.landing-page.mail-services .get-started .choose-product button.active').data('product');
                $('.landing-page.mail-services .get-started .price').hide();
                $('.landing-page.mail-services .get-started .price-' + product).show();
                $('#productKey').val('spamexperts_' + product);
            }
        });

        $('.btn-learn-more').click(function(e) {
            e.preventDefault();
            $('#howitworks a[href="#' + $(this).data('target') + '"]').tab('show');
            smoothScroll('#howitworks');
        });

        $('.btn-buy').click(function(e) {
            e.preventDefault();
            var target = $(this).data('target'),
                pricing = $('#pricing');
            if (target === 'incomingoutgoingarchiving') {
                if (pricing.find('button[data-product="incoming"]').length) {
                    pricing.find('button[data-product="incoming"]').click();
                } else {
                    pricing.find('button[data-product="outgoing"]').click();
                }
                var option = $('input[name="options"][value="incomingoutgoingarchiving"]').first();
                if (option.is(':checked')) {
                    option.click();
                }
                option.click();
            } else {
                pricing.find('button[data-product="' + $(this).data('target') + '"]').click();
            }
            smoothScroll('#pricing');
        });
    });
</script>
